<?php 
    /**
    *
    * copyright (c) 2015-2017 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    */

    class Cifrario {
        private $alfabeto;
        private $variazioneChiave;
        private $indiceDiPartenza;
        private $chiaveCorrente;
        private $carattereSpazio;

        public function __construct($parametri) {
            $this->indiceDiPartenza = $parametri["chiaveIniziale"];
            $this->chiaveCorrente   = $parametri["chiaveIniziale"];
            $this->variazioneChiave = $parametri["variazioneChiave"];
            $this->carattereSpazio  = $parametri["carattereSpazio"];
            $this->alfabeto = str_split("abcdefghilmnopqrstuvzABCDEFGHILMNOPQRSTUVZ");
        }

        /*
         * metodo che cifra la stringa passata in input
        *  @param la $stringa da cifrare
        */
        public function cifra($stringa) {
            $this->chiaveCorrente = $this->indiceDiPartenza;
            $stringaCifrata = "";
            $arrayTemporaneo = str_split($stringa);
            foreach($arrayTemporaneo as $carattere) {
                if($carattere==" ") {
                    $stringaCifrata .= $this->carattereSpazio;
                }
                else {
                    $indice = $this->trovaIndice($carattere);
                    $indiceArrotondato = $this->arrotondaIndice($indice + $this->chiaveCorrente);
                    $stringaCifrata .= $this->alfabeto[$indiceArrotondato];                        
                    $this->chiaveCorrente += $this->variazioneChiave;
                }
            }
            return $stringaCifrata;
        }

        /*
         * metodo che decifra la stringa passata in input
        *  @param la $stringa da decifrare
        */
        public function decifra($stringa) {
            $this->chiaveCorrente = $this->indiceDiPartenza;
            $stringaDecifrata = "";
            $arrayTemporaneo = str_split($stringa);
            foreach($arrayTemporaneo as $carattere) {
                if($carattere==$this->carattereSpazio) {
                    $stringaDecifrata .= " ";
                }
                else {
                    $indice = $this->trovaIndice($carattere);
                    $indiceArrotondato = $this->arrotondaIndice($indice -$this->chiaveCorrente);
                    $stringaDecifrata .= $this->alfabeto[$indiceArrotondato];
                    $this->chiaveCorrente += $this->variazioneChiave;
                }
            }
            return $stringaDecifrata;
        }

        public function arrotondaIndice($indice) {
            if($indice < 0) {
                $indice = $this->arrotondaIndice($indice + 42);
                return $indice;
            }
            else if($indice <42){
                return $indice;
            }
            else {
                $indice = $this->arrotondaIndice($indice -42);
                return $indice;
            }
        }

        /*
         * metodo per trovare l'indice all'interno dell'array contenente
         * l'alfabeto
         */
        public function trovaIndice($carattere) {
            $indice = -1;
            $i = 0;
            foreach($this->alfabeto as $c) {
                if($c==$carattere) {
                    $indice = $i;
                    break;
                }
                else {
                    $i++;
                }
            }
            return $indice;
        }
    }